/*
 * Decompiled with CFR 0.152.
 */
class myDotHandler {
    private boolean[] chkDots = new boolean[100];
    private myDot[] objDots = new myDot[100];
    private myDebugHistory tmpDebugHistory = new myDebugHistory();

    public myDotHandler(myDebugHistory mytmpDebugHistory) {
        int i = 0;
        while (i < 100) {
            this.chkDots[i] = false;
            this.objDots[i] = new myDot(0, 0, 0, "", 0);
            ++i;
        }
        this.tmpDebugHistory = mytmpDebugHistory;
    }

    public String getDotName(int Index) {
        this.tmpDebugHistory.doAddLine("[request] dot.getname request");
        this.chkDots[Index] = true;
        if (true) {
            this.tmpDebugHistory.doAddLine("[information] name of dot returned: " + Integer.toString(Index));
            return this.objDots[Index].getName();
        }
        this.tmpDebugHistory.doAddLine("[error] unable to return dot.name: dot does not exist: " + Integer.toString(Index));
        return "<wrong index>";
    }

    public int[] getDotCoordinate(int idDot) {
        int[] temp = new int[]{-99, -99, -99};
        int i = 0;
        while (i < 100) {
            if (this.chkDots[i] && this.objDots[i].getID() == idDot) {
                temp = this.objDots[i].getCoordinates();
                return temp;
            }
            ++i;
        }
        return temp;
    }

    public int[][] getCoordinates() {
        this.tmpDebugHistory.doAddLine("[request] all dot.getcoordination request");
        int[][] temp = new int[100][3];
        int i = 0;
        while (i < 100) {
            if (this.chkDots[i]) {
                temp[i] = this.objDots[i].getCoordinates();
            } else {
                temp[i][0] = -99;
                temp[i][1] = -99;
                temp[i][2] = -99;
            }
            ++i;
        }
        return temp;
    }

    public int doAddDot(int x, int y, int z, String name) {
        this.tmpDebugHistory.doAddLine("[request] dot.doadd request");
        int tmp = this.doSearchFreeSlot();
        if (tmp > -1) {
            int id = this.getFreeID();
            if (id > -1) {
                this.chkDots[tmp] = true;
                this.objDots[tmp].setCoordinates(x, y, z);
                this.objDots[tmp].setName(name);
                this.objDots[tmp].setID(id);
                this.tmpDebugHistory.doAddLine("[information] new dot created! slot: " + Integer.toString(tmp) + " id: " + Integer.toString(id) + " name: " + name + " coords: " + Integer.toString(x) + "|" + Integer.toString(y) + "|" + Integer.toString(z));
                return 0;
            }
            this.tmpDebugHistory.doAddLine("[error] unable to create new dot: no id could be found");
            return 1;
        }
        this.tmpDebugHistory.doAddLine("[error] unable to create new dot: no free slot could found");
        return 1;
    }

    private int getFreeID() {
        this.tmpDebugHistory.doAddLine("[request] dot.getnewid request");
        int i = 1000;
        while (i < 2000) {
            boolean tmp = true;
            int j = 0;
            while (j < 100 && tmp) {
                if (this.chkDots[j] && this.objDots[j].getID() == i) {
                    tmp = false;
                }
                ++j;
            }
            if (tmp) {
                this.tmpDebugHistory.doAddLine("[information] free id found: " + Integer.toString(i));
                return i;
            }
            ++i;
        }
        this.tmpDebugHistory.doAddLine("[error] no free id could be found");
        return -1;
    }

    public int doRemoveDot(int x, int y, int z) {
        this.tmpDebugHistory.doAddLine("[request] dot.doremove request");
        int[] temp = new int[3];
        int i = 0;
        while (i < 100) {
            if (this.chkDots[i] && (temp = this.objDots[i].getCoordinates())[0] == x && temp[1] == y && temp[2] == z) {
                this.chkDots[i] = false;
                this.objDots[i].setCoordinates(0, 0, 0);
                this.objDots[i].setName("");
                this.objDots[i].setID(0);
                this.tmpDebugHistory.doAddLine("[information] dot removed successfully");
                return 0;
            }
            ++i;
        }
        this.tmpDebugHistory.doAddLine("[error] unable to remove dot: coordinates could not be resolved");
        return 1;
    }

    private int doSearchFreeSlot() {
        this.tmpDebugHistory.doAddLine("[request] dot.getnewslot request");
        int i = 0;
        while (i < 100) {
            if (!this.chkDots[i]) {
                this.tmpDebugHistory.doAddLine("[information] free slot found: " + Integer.toString(i));
                return i;
            }
            ++i;
        }
        this.tmpDebugHistory.doAddLine("[error] no free slot could be found");
        return -1;
    }

    public boolean doesSlotExist(int Index) {
        return this.chkDots[Index];
    }

    public int getDotID(int X, int Y, int Z) {
        int[] temp = new int[3];
        int i = 0;
        while (i < 100) {
            if (this.doesSlotExist(i) && (temp = this.objDots[i].getCoordinates())[0] == X && temp[1] == Y && temp[2] == Z) {
                return this.objDots[i].getID();
            }
            ++i;
        }
        return -99999;
    }
}

