/*
 * Decompiled with CFR 0.152.
 */
package telefon;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import telefon.cAccess;
import telefon.cMain;
import telefon.cMyTableModel;
import telefon.cTelefonbuch;
import telefon.frmNeuerEintrag;

public class frmHauptmenue
extends JFrame
implements ActionListener,
WindowListener,
TableModelListener,
KeyListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private cAccess access = cMain.access;
    private cTelefonbuch telefon = cMain.telefon;
    private frmNeuerEintrag FormNeuerEintrag = cMain.FormNeuerEintrag;
    private String[] cols = new String[]{"Nr", "Name", "Vorname", "Vorwahl", "Telefonnummer"};
    private cMyTableModel model = new cMyTableModel(this.cols, 0);
    private String filter = "";
    private int SelectedRow;
    private String[][] dbData;
    private JPanel jPanel;
    private JLabel lblSuchen;
    private JTextField txtSuchen;
    private JTable tabelle;
    private JScrollPane scrollPane;
    private JMenuBar jMenuBar;
    private JMenu jMenuDatei;
    private JMenuItem jMenuNeu;
    private JMenuItem jMenuBeenden;
    private JPopupMenu jPopupMenu;
    private JMenuItem jMenuDelete;

    public frmHauptmenue() {
        this.access.connect();
        this.initComponents();
        this.setDefaultCloseOperation(2);
    }

    private void initComponents() {
        this.jPanel = new JPanel();
        this.lblSuchen = new JLabel("Suchen:");
        this.txtSuchen = new JTextField("");
        this.jMenuBar = new JMenuBar();
        this.jMenuDatei = new JMenu("Datei");
        this.jMenuNeu = new JMenuItem("Neuer Eintrag");
        this.jMenuBeenden = new JMenuItem("Programm Beenden");
        this.jMenuDatei.add(this.jMenuNeu);
        this.jMenuDatei.add(this.jMenuBeenden);
        this.jMenuBar.add(this.jMenuDatei);
        this.setJMenuBar(this.jMenuBar);
        this.jMenuDelete = new JMenuItem("Eintrag l\u00f6schen");
        this.jPopupMenu = new JPopupMenu();
        this.jPopupMenu.add(this.jMenuDelete);
        this.model.setColumnNonEditable(0);
        this.tabelle = new JTable(this.model);
        this.tabelle.getTableHeader().setReorderingAllowed(false);
        this.tabelle.setSelectionMode(0);
        this.buildTable(true);
        this.tabelle.getColumn(this.tabelle.getColumnName(0)).setPreferredWidth(5);
        this.tabelle.getColumn(this.tabelle.getColumnName(4)).setPreferredWidth(100);
        this.scrollPane = new JScrollPane(this.tabelle);
        GroupLayout layout = new GroupLayout(this.jPanel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.jPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.lblSuchen).addComponent(this.txtSuchen)).addComponent(this.scrollPane));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.lblSuchen).addComponent(this.txtSuchen)).addComponent(this.scrollPane));
        this.getContentPane();
        this.add(this.jPanel);
        this.txtSuchen.addKeyListener(this);
        this.jMenuNeu.addActionListener(this);
        this.jMenuBeenden.addActionListener(this);
        this.jMenuDelete.addActionListener(this);
        this.model.addTableModelListener(this);
        this.tabelle.addMouseListener(this);
        this.setTitle("Telefonbuch v0.1");
        this.setLocation(30, 60);
        this.setSize(400, 300);
        this.setVisible(true);
    }

    public void buildTable(boolean loadDataFromDatabase) {
        this.model.setRowCount(0);
        if (loadDataFromDatabase) {
            this.dbData = this.telefon.getDataFromDatabase();
        }
        Object[] row = new Object[6];
        int i = 0;
        while (i < this.dbData.length) {
            row[0] = "" + (i + 1);
            row[1] = this.dbData[i][1];
            row[2] = this.dbData[i][2];
            row[3] = this.dbData[i][3];
            row[4] = this.dbData[i][4];
            this.model.addRow(row);
            ++i;
        }
    }

    public boolean isValidInput(int row, int col) {
        String value = this.model.getValueAt(row, col).toString();
        switch (col) {
            case 1: {
                return this.telefon.isValidName(value);
            }
            case 2: {
                return this.telefon.isValidVorname(value);
            }
            case 3: {
                return this.telefon.isValidVorwahl(value);
            }
            case 4: {
                return this.telefon.isValidTelefonNummer(value);
            }
        }
        return false;
    }

    public void loescheEintrag() {
        Object[] options = new Object[]{"Ja", "Nein"};
        int n = JOptionPane.showOptionDialog(this, "Wollen Sie den Eintrag wirklich l\u00f6schen?", "Eintrag l\u00f6schen?", 0, 3, null, options, options[0]);
        if (n == 0) {
            String ID = this.dbData[this.SelectedRow][0];
            this.access.query("DELETE FROM eintraege WHERE ID = " + ID);
            this.buildTable(true);
        }
    }

    public void loescheEintrag(int row) {
        Object[] options = new Object[]{"Ja", "Nein"};
        int n = JOptionPane.showOptionDialog(this, "Wollen Sie den Eintrag wirklich l\u00f6schen?", "Eintrag l\u00f6schen?", 0, 3, null, options, options[0]);
        if (n == 0) {
            String ID = this.dbData[row][0];
            this.access.query("DELETE FROM eintraege WHERE ID = " + ID);
            this.buildTable(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object which = e.getSource();
        if (which.equals(this.jMenuNeu)) {
            this.FormNeuerEintrag = new frmNeuerEintrag();
            this.FormNeuerEintrag.addWindowListener(this);
        } else if (which.equals(this.jMenuDelete)) {
            this.loescheEintrag();
        } else if (which.equals(this.jMenuBeenden)) {
            System.exit(0);
        }
    }

    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int col = e.getColumn();
        if (row == -1 || col == -1) {
            return;
        }
        String oldValue = this.dbData[row][col];
        String NewValue = this.model.getValueAt(row, col).toString();
        if (col > 0 && oldValue.compareTo(NewValue) != 0) {
            Object[] options = new Object[]{"Jop", "Achwas"};
            int n = JOptionPane.showOptionDialog(this, "Wollen Sie den Wert speichern?", "Eintrag \u00e4ndern?", 0, 3, null, options, options[0]);
            if (n == 0) {
                String colName = this.model.getColumnName(col);
                String ID = this.dbData[row][0];
                if (this.isValidInput(row, col)) {
                    this.access.query("UPDATE eintraege SET " + colName + "='" + NewValue + "' WHERE ID = " + ID);
                } else {
                    JOptionPane.showMessageDialog(this, "Die Eingabe ist falsch!");
                    this.model.setValueAt(oldValue, row, col);
                }
            } else {
                this.model.setValueAt(oldValue, row, col);
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        Object which = e.getSource();
        if (which.equals(this.FormNeuerEintrag)) {
            this.buildTable(true);
        }
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        Object which = e.getSource();
        if (which.equals(this.txtSuchen)) {
            this.filter = this.txtSuchen.getText();
            if (this.filter.length() > 0 && !this.filter.matches("[a-zA-Z_0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df -()]++")) {
                try {
                    this.txtSuchen.setText(this.txtSuchen.getText(0, this.txtSuchen.getText().length() - 1));
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
            if (this.filter.length() >= 3) {
                this.dbData = this.telefon.getDataFromDatabase(this.filter);
                this.buildTable(false);
            } else {
                this.buildTable(true);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            Point punkt = e.getPoint();
            this.SelectedRow = this.tabelle.rowAtPoint(punkt);
            this.tabelle.setRowSelectionInterval(this.SelectedRow, this.tabelle.rowAtPoint(e.getPoint()));
            this.jPopupMenu.show(this.tabelle, punkt.x, punkt.y);
            this.jPopupMenu.setVisible(true);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

