/*
 * Decompiled with CFR 0.152.
 */
package Zeichenbereich;

import Zeichenbereich.BereichsEinstellungen;
import java.awt.Color;
import java.awt.Graphics;

public class FunktionenXGradesErstellen
extends BereichsEinstellungen {
    private static final long serialVersionUID = 1L;
    private int grad = 0;
    private double[] funktion;
    private boolean showableitungen = false;
    private int showsteigung = 0;
    private String legende = "";

    public void setShowSteigung(int i) {
        if (this.grad == 0 || this.grad == 1) {
            this.showsteigung = i;
        }
    }

    public void setGerade(double xQuadratFunktion, int xGrad) {
        this.grad = 0;
        this.funktion = new double[2];
        this.funktion[0] = xQuadratFunktion;
    }

    public void setGerade(double[] xQuadratFunktion, int xGrad) {
        this.funktion = xGrad == 0 ? new double[2] : new double[xGrad + 1];
        int i = 0;
        while (i <= xGrad) {
            this.funktion[i] = xQuadratFunktion[i];
            ++i;
        }
        this.grad = xGrad;
    }

    private double quadratZahl(double zahl, int wievielfach) {
        if (wievielfach == 0) {
            return 1.0;
        }
        double zwischen = zahl;
        int i = 2;
        while (i <= wievielfach) {
            zwischen *= zahl;
            ++i;
        }
        return zwischen;
    }

    public int getYwert(double xwert) {
        double ywert = 0.0;
        int i = 0;
        while (i <= this.grad) {
            ywert += this.funktion[i] * this.quadratZahl(xwert, i);
            ++i;
        }
        return this.umrechnungy(ywert);
    }

    public double getSteigung(double xwert) {
        if (this.grad > 0) {
            double[] ableitung = new double[this.grad];
            int i = 1;
            while (i <= this.grad) {
                ableitung[i - 1] = this.funktion[i] * (double)i;
                ++i;
            }
            double steigung = 0.0;
            int i2 = 0;
            while (i2 <= this.grad - 1) {
                steigung += ableitung[i2] * this.quadratZahl(xwert, i2);
                ++i2;
            }
            return steigung;
        }
        return 0.0;
    }

    public void zeichne(Graphics myg) {
        int ywert;
        int i = this.xAchseMin;
        while (i <= this.xAchseMax) {
            ywert = this.getYwert(this.umrechnungx(i));
            if (ywert <= this.yAchseMax && ywert >= this.yAchseMin) {
                myg.drawLine(i, ywert, i, ywert);
            }
            ++i;
        }
        int ver\u00fcckt = -12;
        if (this.showableitungen) {
            myg.drawString("Funktion", this.xAchseMin + 10, this.yAchseMax - ver\u00fcckt);
            i = this.xAchseMin;
            while (i <= this.xAchseMax) {
                ywert = this.getYwerta1(this.umrechnungx(i));
                myg.setColor(Color.LIGHT_GRAY);
                if (ywert <= this.yAchseMax && ywert >= this.yAchseMin) {
                    myg.drawLine(i, ywert, i, ywert);
                }
                ++i;
            }
            myg.drawString("Erste Ableitung", this.xAchseMin + 90, this.yAchseMax - ver\u00fcckt);
            i = this.xAchseMin;
            while (i <= this.xAchseMax) {
                myg.setColor(Color.BLACK);
                ywert = this.getYwerta2(this.umrechnungx(i));
                if (ywert <= this.yAchseMax && ywert >= this.yAchseMin) {
                    myg.drawLine(i, ywert, i, ywert);
                }
                ++i;
            }
            myg.drawString("Zweite Ableitung", this.xAchseMin + 200, this.yAchseMax - ver\u00fcckt);
        }
        if (this.showsteigung == 1) {
            myg.drawString("Steigung der Tangente: " + this.funktion[1], this.xAchseMin + 300, this.yAchseMax - ver\u00fcckt);
        }
        if (this.showsteigung == 2) {
            myg.drawString("Steigung der Sekante: " + this.funktion[1], this.xAchseMin + 10, this.yAchseMax - ver\u00fcckt);
        }
        if (this.legende != "") {
            myg.drawString(this.legende, this.xAchseMax - 90, this.yAchseMax - ver\u00fcckt);
        }
    }

    public int getYwerta1(double xwert) {
        double ywert = 0.0;
        int i = 0;
        while (i <= this.grad) {
            ywert += this.funktion[i] * this.quadratZahl(xwert, i - 1) * (double)i;
            ++i;
        }
        return this.umrechnungy(ywert);
    }

    public int getYwerta2(double xwert) {
        double ywert = 0.0;
        int i = 0;
        while (i <= this.grad) {
            ywert += this.funktion[i] * this.quadratZahl(xwert, i - 2) * (double)i * (double)(i - 1);
            ++i;
        }
        return this.umrechnungy(ywert);
    }

    public void setShowableitungen() {
        this.showableitungen = true;
    }

    public void setLegende(String legende) {
        this.legende = legende;
    }
}

