/*
 * Decompiled with CFR 0.152.
 */
package pack1;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import pack1.Point2DDouble;
import pack1.Transformation;
import pack1.ZeichnungJPanel;

public class Tangente {
    private ZeichnungJPanel zeichnungJPanel;
    private Point2DDouble festPunkt;
    private Point2DDouble laufPunkt;
    private Image bildNormalparabel;
    private double abstand;

    public Tangente(ZeichnungJPanel pZeichnungJPanel) {
        this.zeichnungJPanel = pZeichnungJPanel;
        this.festPunkt = new Point2DDouble(0.0, 0.0);
        this.laufPunkt = new Point2DDouble(0.0, 0.0);
        this.abstand = 0.1;
    }

    public void setFestPunkt(double px, double py) {
        this.festPunkt.x = px;
        this.festPunkt.y = py;
    }

    public Point2DDouble getFestPunkt() {
        return this.festPunkt;
    }

    public void setLaufPunkt(double px, double py) {
        this.laufPunkt.x = px;
        this.laufPunkt.y = py;
    }

    public Point2DDouble getLaufPunkt() {
        return this.laufPunkt;
    }

    public void berechnePos() {
        double parameterXFestpunkt;
        double parameterDeltaX = this.zeichnungJPanel.getParameterDeltaX();
        this.festPunkt.x = parameterXFestpunkt = this.zeichnungJPanel.getParameterXFestpunkt();
        this.festPunkt.y = this.festPunkt.x * this.festPunkt.x;
        this.laufPunkt.x = this.festPunkt.x + parameterDeltaX;
        this.laufPunkt.y = this.laufPunkt.x * this.laufPunkt.x;
    }

    public void zeichneSekante(Graphics g, Color farbe) {
        double x1 = this.laufPunkt.x;
        double y1 = this.laufPunkt.y;
        double x2 = this.laufPunkt.x;
        double y2 = this.festPunkt.y;
        g.setColor(Color.red);
        this.drawLineWelt(g, x1, y1, x2, y2);
        this.drawPunktWelt(g, Color.magenta, this.festPunkt.x, this.festPunkt.y);
        this.drawPunktWelt(g, Color.darkGray, this.laufPunkt.x, this.laufPunkt.y);
        x1 = this.festPunkt.x;
        y1 = this.festPunkt.y;
        x2 = this.laufPunkt.x;
        y2 = this.festPunkt.y;
        g.setColor(Color.blue);
        this.drawLineWelt(g, x1, y1, x2, y2);
        x1 = Transformation.wMinX;
        y1 = (this.laufPunkt.y - this.festPunkt.y) / (this.laufPunkt.x - this.festPunkt.x) * (x1 - this.festPunkt.x) + this.festPunkt.y;
        x2 = Transformation.wMaxX;
        y2 = (this.laufPunkt.y - this.festPunkt.y) / (this.laufPunkt.x - this.festPunkt.x) * (x2 - this.festPunkt.x) + this.festPunkt.y;
        g.setColor(farbe);
        this.drawLineWelt(g, x1, y1, x2, y2);
    }

    public void zeichneTangente(Graphics g, Color farbe) {
        g.setColor(farbe);
        double xBeginn = Transformation.wMinX;
        double xEnde = Transformation.wMaxX;
        double yBeginn = 2.0 * this.festPunkt.x * (xBeginn - this.festPunkt.x) + this.festPunkt.y;
        double yEnde = 2.0 * this.festPunkt.x * (xEnde - this.festPunkt.x) + this.festPunkt.y;
        this.drawLineWelt(g, xBeginn, yBeginn, xEnde, yEnde);
    }

    public void zeichneAchsenkreuz(Graphics g, Color farbe) {
        Point2DDouble A2D = new Point2DDouble(0.0, 0.0);
        Point2DDouble B2D = new Point2DDouble(0.0, 0.0);
        g.setColor(farbe);
        A2D.x = Transformation.wMinX;
        A2D.y = 0.0;
        B2D.x = Transformation.wMaxX;
        B2D.y = 0.0;
        this.drawLineWelt(g, A2D.x, A2D.y, B2D.x, B2D.y);
        this.drawDreieckWelt(g, Color.black, B2D.x, B2D.y, B2D.x - 0.2, B2D.y + 0.2, B2D.x - 0.2, B2D.y - 0.2);
        this.beschrifteAchsenkreuz(g, farbe);
        A2D.x = 0.0;
        A2D.y = Transformation.wMinY;
        B2D.x = 0.0;
        B2D.y = Transformation.wMaxY;
        this.drawLineWelt(g, A2D.x, A2D.y, B2D.x, B2D.y);
        this.drawDreieckWelt(g, Color.black, B2D.x, B2D.y, B2D.x - 0.2, B2D.y - 0.2, B2D.x + 0.2, B2D.y - 0.2);
    }

    public void beschrifteAchsenkreuz(Graphics g, Color farbe) {
        double min = Transformation.wMinX;
        double max = Transformation.wMaxX;
        double x = 0.0;
        do {
            this.drawLineWelt(g, x, 0.1, x, -0.1);
        } while ((x += 1.0) <= max);
        x = 0.0;
        do {
            this.drawLineWelt(g, x, 0.1, x, -0.1);
        } while ((x -= 1.0) >= min);
        min = Transformation.wMinY;
        max = Transformation.wMaxY;
        double y = 0.0;
        do {
            this.drawLineWelt(g, -0.1, y, 0.1, y);
        } while ((y += 1.0) <= max);
        do {
            this.drawLineWelt(g, -0.1, y, 0.1, y);
        } while ((y -= 1.0) >= min);
    }

    public void zeichneNormalparabel(Graphics g, Color farbe) {
        Graphics graphicsNormalparabel = null;
        int breiteInPixel = Transformation.getScreenBreite();
        g.setColor(farbe);
        int sx = this.zeichnungJPanel.getSize().width;
        int sy = this.zeichnungJPanel.getSize().height;
        if ((this.bildNormalparabel == null || this.bildNormalparabel.getWidth(null) != sx || this.bildNormalparabel.getHeight(null) != sy) && sx != 0 && sy != 0) {
            this.bildNormalparabel = this.zeichnungJPanel.createImage(sx, sy);
        }
        if (sx != 0 && sy != 0) {
            graphicsNormalparabel = this.bildNormalparabel.getGraphics();
            graphicsNormalparabel.setColor(this.zeichnungJPanel.getBackground());
            graphicsNormalparabel.fillRect(0, 0, sx, sy);
            graphicsNormalparabel.setColor(farbe);
            double wMinX = Transformation.wMinX;
            int xScreenAlt = Transformation.transform2DWeltToScreenX(wMinX);
            int yScreenAlt = Transformation.transform2DWeltToScreenY(wMinX * wMinX);
            int xScreen = xScreenAlt;
            int yScreen = yScreenAlt;
            for (int i = 1; i < breiteInPixel; ++i) {
                double xw = Transformation.transformScreenTo2DWeltX(++xScreen);
                double yw = xw * xw;
                yScreen = Transformation.transform2DWeltToScreenY(yw);
                graphicsNormalparabel.drawLine(xScreenAlt, yScreenAlt, xScreen, yScreen);
                graphicsNormalparabel.drawLine(xScreenAlt, yScreenAlt, xScreenAlt, yScreenAlt);
                xScreenAlt = xScreen;
                yScreenAlt = yScreen;
            }
        }
        g.drawImage(this.bildNormalparabel, 0, 0, null);
    }

    public void drawLineWelt(Graphics g, double x1, double y1, double x2, double y2) {
        Point A2DScreen = Transformation.transform2DWeltToScreen(x1, y1);
        Point B2DScreen = Transformation.transform2DWeltToScreen(x2, y2);
        g.drawLine(A2DScreen.x, A2DScreen.y, B2DScreen.x, B2DScreen.y);
    }

    public void drawDreieckWelt(Graphics g, Color farbe, double x1, double y1, double x2, double y2, double x3, double y3) {
        g.setColor(farbe);
        Point A2DScreen = Transformation.transform2DWeltToScreen(x1, y1);
        Point B2DScreen = Transformation.transform2DWeltToScreen(x2, y2);
        Point C2DScreen = Transformation.transform2DWeltToScreen(x3, y3);
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        xPoints[0] = A2DScreen.x;
        xPoints[1] = B2DScreen.x;
        xPoints[2] = C2DScreen.x;
        yPoints[0] = A2DScreen.y;
        yPoints[1] = B2DScreen.y;
        yPoints[2] = C2DScreen.y;
        g.fillPolygon(xPoints, yPoints, 3);
    }

    public void drawPunktWelt(Graphics g, Color farbe, double x, double y) {
        g.setColor(farbe);
        double xobenlinks = x - this.abstand;
        double yobenlinks = y + this.abstand;
        double xuntenrechts = x + this.abstand;
        double yuntenrechts = y - this.abstand;
        Point A2DScreen = Transformation.transform2DWeltToScreen(xobenlinks, yobenlinks);
        Point B2DScreen = Transformation.transform2DWeltToScreen(xuntenrechts, yuntenrechts);
        int javaAbstand = B2DScreen.x - A2DScreen.x;
        g.fillOval(A2DScreen.x, A2DScreen.y, javaAbstand, javaAbstand);
    }

    public boolean istInnerhalb(Point pJavaklick, Point2DDouble p2D) {
        double x = p2D.x;
        double y = p2D.y;
        double xobenlinks = x - this.abstand;
        double yobenlinks = y + this.abstand;
        double xuntenrechts = x + this.abstand;
        double yuntenrechts = y - this.abstand;
        Point A2DScreen = Transformation.transform2DWeltToScreen(xobenlinks, yobenlinks);
        Point B2DScreen = Transformation.transform2DWeltToScreen(xuntenrechts, yuntenrechts);
        int xobenlinksScreen = A2DScreen.x;
        int yobenlinksScreen = A2DScreen.y;
        int xuntenrechtsScreen = B2DScreen.x;
        int yuntenrechtsScreen = B2DScreen.y;
        boolean b = pJavaklick.x > xobenlinksScreen && pJavaklick.x < xuntenrechtsScreen && pJavaklick.y > yobenlinksScreen && pJavaklick.y < yuntenrechtsScreen;
        return b;
    }
}

