/*
 * Decompiled with CFR 0.152.
 */
package pack1;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import pack1.Point3DDouble;
import pack1.PointDouble;
import pack1.Transformation;
import pack1.ZeichnungJPanel;

public class Gerade {
    private ZeichnungJPanel zeichnungJPanel;
    private Color farbe;
    private double x1;
    private double x2;
    private double x3;
    private double vx1;
    private double vx2;
    private double vx3;
    private double ax1;
    private double ax2;
    private double ax3;

    public Gerade(ZeichnungJPanel pzeichnungJPanel) {
        this.zeichnungJPanel = pzeichnungJPanel;
    }

    public void initGerade(Color pFarbe, double ax1, double ax2, double ax3, double vx1, double vx2, double vx3) {
        this.farbe = pFarbe;
        this.setAX(ax1, ax2, ax3);
        this.setVX(vx1, vx2, vx3);
    }

    public void geradeFestlegen(double pax1, double pax2, double pax3, double pvx1, double pvx2, double pvx3) {
        this.ax1 = pax1;
        this.ax2 = pax2;
        this.ax3 = pax3;
        this.vx1 = pvx1;
        this.vx2 = pvx2;
        this.vx3 = pvx3;
    }

    public double getX1() {
        return this.x1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getX3() {
        return this.x3;
    }

    public double getaX1() {
        return this.ax1;
    }

    public double getaX2() {
        return this.ax2;
    }

    public double getaX3() {
        return this.ax3;
    }

    public double getvX1() {
        return this.vx1;
    }

    public double getvX2() {
        return this.vx2;
    }

    public double getvX3() {
        return this.vx3;
    }

    private void berechneAnfangUndEnde(Point anfangsPunkt, Point endPunkt) {
        double t = 100.0;
        double bX1 = this.ax1 + t * this.vx1;
        double bX2 = this.ax2 + t * this.vx2;
        double bX3 = this.ax3 + t * this.vx3;
        t = -t;
        double eX1 = this.ax1 + t * this.vx1;
        double eX2 = this.ax2 + t * this.vx2;
        double eX3 = this.ax3 + t * this.vx3;
        anfangsPunkt.x = Transformation.transform3DToJava((double)bX1, (double)bX2, (double)bX3).x;
        anfangsPunkt.y = Transformation.transform3DToJava((double)bX1, (double)bX2, (double)bX3).y;
        endPunkt.x = Transformation.transform3DToJava((double)eX1, (double)eX2, (double)eX3).x;
        endPunkt.y = Transformation.transform3DToJava((double)eX1, (double)eX2, (double)eX3).y;
    }

    public void setAX(double pax1, double pax2, double pax3) {
        this.ax1 = pax1;
        this.ax2 = pax2;
        this.ax3 = pax3;
    }

    public void setVX(double pvx1, double pvx2, double pvx3) {
        this.vx1 = pvx1;
        this.vx2 = pvx2;
        this.vx3 = pvx3;
    }

    public void setFarbe(Color pFarbe) {
        this.farbe = pFarbe;
    }

    public Color getFarbe() {
        return this.farbe;
    }

    void berechnePos() {
        double t = this.zeichnungJPanel.getParameterT();
        this.x1 = this.ax1 + t * this.vx1;
        this.x2 = this.ax2 + t * this.vx2;
        this.x3 = this.ax3 + t * this.vx3;
    }

    void zeichneAchsenkreuz(Graphics g, Color farbe) {
        Point achsenBeschriftungAnfang = new Point(0, 0);
        Point3DDouble A3D = new Point3DDouble(0.0, 0.0, 0.0);
        Point3DDouble B3D = new Point3DDouble(0.0, 0.0, 0.0);
        g.setColor(farbe);
        B3D.x1 = 0.0;
        B3D.x2 = 0.0;
        B3D.x3 = Transformation.hoehe / 2.0 / Transformation.ex;
        this.zeichnePfeil(g, farbe, A3D, B3D);
        achsenBeschriftungAnfang = Transformation.transform3DToJava(0.0, -0.1, 1.0);
        g.drawRect(achsenBeschriftungAnfang.x, achsenBeschriftungAnfang.y, 5, 1);
        B3D.x1 = 0.0;
        B3D.x2 = Transformation.breite / 2.0 / Transformation.ex;
        B3D.x3 = 0.0;
        this.zeichnePfeil(g, farbe, A3D, B3D);
        achsenBeschriftungAnfang = Transformation.transform3DToJava(0.0, 1.0, 0.05);
        g.drawRect(achsenBeschriftungAnfang.x, achsenBeschriftungAnfang.y, 1, 5);
        B3D.x1 = Math.sqrt(2.0) * Transformation.hoehe / 2.0 / Transformation.ex1;
        B3D.x2 = 0.0;
        B3D.x3 = 0.0;
        this.zeichnePfeil(g, farbe, A3D, B3D);
        achsenBeschriftungAnfang = Transformation.transform3DToJava(1.0, -0.1, 0.0);
        g.drawRect(achsenBeschriftungAnfang.x, achsenBeschriftungAnfang.y, 5, 1);
    }

    void zeichneAufpunkt(Graphics g, Color farbe) {
        int punktDicke = 5;
        PointDouble A = new PointDouble(0.0, 0.0);
        Point AJava = new Point(0, 0);
        g.setColor(farbe);
        A = Transformation.transform3DTo2D(this.ax1, this.ax2, this.ax3);
        double xPunkt = A.x - (double)punktDicke;
        double yPunkt = A.y + (double)punktDicke;
        AJava = Transformation.transform2DToJava(xPunkt, yPunkt);
        g.fillOval(AJava.x, AJava.y, 2 * punktDicke, 2 * punktDicke);
        AJava = Transformation.transform2DToJava(xPunkt + (double)(2 * punktDicke), yPunkt);
        g.drawString("A", AJava.x, AJava.y);
    }

    void zeichneRichtungsvektor(Graphics g, Color farbe) {
        double abstandBeschriftung = 5.0;
        Point3DDouble A3D = new Point3DDouble(0.0, 0.0, 0.0);
        Point3DDouble E3D = new Point3DDouble(0.0, 0.0, 0.0);
        Point3DDouble M3D = new Point3DDouble(0.0, 0.0, 0.0);
        PointDouble M2D = new PointDouble(0.0, 0.0);
        Point MJava = new Point(0, 0);
        g.setColor(farbe);
        A3D.x1 = this.ax1;
        A3D.x2 = this.ax2;
        A3D.x3 = this.ax3;
        E3D.x1 = this.ax1 + this.vx1;
        E3D.x2 = this.ax2 + this.vx2;
        E3D.x3 = this.ax3 + this.vx3;
        this.zeichnePfeil(g, farbe, A3D, E3D);
        M3D.x1 = (A3D.x1 + E3D.x1) / 2.0;
        M3D.x2 = (A3D.x2 + E3D.x2) / 2.0;
        M3D.x3 = (A3D.x3 + E3D.x3) / 2.0;
        M2D = Transformation.transform3DTo2D(M3D.x1, M3D.x2, M3D.x3);
        double xBeschriftung = M2D.x + abstandBeschriftung;
        double yBeschriftung = M2D.y + abstandBeschriftung;
        MJava = Transformation.transform2DToJava(xBeschriftung, yBeschriftung);
        g.drawString("v", MJava.x, MJava.y);
    }

    void zeichneGerade(Graphics g, Color farbe) {
        Point anfangsPunkt = new Point(0, 0);
        Point endPunkt = new Point(0, 0);
        this.berechneAnfangUndEnde(anfangsPunkt, endPunkt);
        g.setColor(farbe);
        g.drawLine(anfangsPunkt.x, anfangsPunkt.y, endPunkt.x, endPunkt.y);
    }

    void zeichneOrtsvektor(Graphics g, Color farbe) {
        Point anfangOrtsvektor1 = new Point(0, 0);
        Point endeOrtsvektor1 = new Point(0, 0);
        PointDouble anfangOrtsvektor2 = new PointDouble(0.0, 0.0);
        PointDouble endeOrtsvektor2 = new PointDouble(0.0, 0.0);
        g.setColor(farbe);
        anfangOrtsvektor1 = Transformation.transform3DToJava(0.0, 0.0, 0.0);
        endeOrtsvektor1 = Transformation.transform3DToJava(this.x1, this.x2, this.x3);
        g.drawLine(anfangOrtsvektor1.x, anfangOrtsvektor1.y, endeOrtsvektor1.x, endeOrtsvektor1.y);
        anfangOrtsvektor2 = Transformation.transform3DTo2D(0.0, 0.0, 0.0);
        endeOrtsvektor2 = Transformation.transform3DTo2D(this.x1, this.x2, this.x3);
        this.zeichnePfeilspitze(g, farbe, anfangOrtsvektor2, endeOrtsvektor2);
    }

    void zeichnePfeil(Graphics g, Color farbe, Point3DDouble A, Point3DDouble B) {
        g.setColor(farbe);
        Point AJava = Transformation.transform3DToJava(A.x1, A.x2, A.x3);
        Point BJava = Transformation.transform3DToJava(B.x1, B.x2, B.x3);
        g.drawLine(AJava.x, AJava.y, BJava.x, BJava.y);
        PointDouble A2D = Transformation.transform3DTo2D(A.x1, A.x2, A.x3);
        PointDouble B2D = Transformation.transform3DTo2D(B.x1, B.x2, B.x3);
        this.zeichnePfeilspitze(g, farbe, A2D, B2D);
    }

    void zeichnePfeilspitze(Graphics graphics, Color farbe, PointDouble A, PointDouble B) {
        double k;
        PointDouble R = new PointDouble(0.0, 0.0);
        PointDouble Q = new PointDouble(0.0, 0.0);
        double g = 5.0;
        double l = 10.0;
        double xA = A.x;
        double xB = B.x;
        double yA = A.y;
        double yB = B.y;
        double xAB = xB - xA;
        double yAB = yB - yA;
        if (xAB > -0.001 && xAB < 0.001) {
            xAB = 0.001;
        }
        if (yAB > -0.001 && yAB < 0.001) {
            yAB = 0.001;
        }
        double m = yAB / xAB;
        double s = -1.0 / m;
        double h = Math.sqrt(l * l - g * g);
        double f = Math.sqrt(yAB * yAB + xAB * xAB);
        double xAC = (f - h) / f * xAB;
        double yAC = (f - h) / f * yAB;
        double xCQ = k = g / Math.sqrt(1.0 + s * s);
        double yCQ = k * s;
        double xQ = xA + xAC + xCQ;
        double yQ = yA + yAC + yCQ;
        double xR = xA + xAC - xCQ;
        double yR = yA + yAC - yCQ;
        R.x = xR;
        R.y = yR;
        Q.x = xQ;
        Q.y = yQ;
        Point B_Java = Transformation.transform2DToJava(B.x, B.y);
        Point Q_Java = Transformation.transform2DToJava(Q.x, Q.y);
        Point R_Java = Transformation.transform2DToJava(R.x, R.y);
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        xPoints[0] = B_Java.x;
        xPoints[1] = Q_Java.x;
        xPoints[2] = R_Java.x;
        yPoints[0] = B_Java.y;
        yPoints[1] = Q_Java.y;
        yPoints[2] = R_Java.y;
        graphics.setColor(farbe);
        graphics.drawPolygon(xPoints, yPoints, 3);
        graphics.fillPolygon(xPoints, yPoints, 3);
    }
}

